%%% Primitive Set for List Manipulation %%%
:- modeb(1,nil(+list))?
:- modeb(1,+list = [-nonlist|-list],[functional])?
:- modeb(1,-list = [+nonlist|+list],[functional])?
:- modeb(1,listify(+nonlist,-list),[functional])?

%:- modeb(*,member(-nonlist,+list),[functional])?
%:- modeb(*,member(+nonlist,-list),[functional])?
%:- modeb(1,length(+list,-int),[functional])?

%%% Entailments
:- nil(L) => L = [_|_]?


%%% List Definitions
%member(E,[E|_]).
%member(E,[_|T]) :- member(E,T).
%length(L,N) :- length(L,0,N). % use version with accumulator for tail-recursion
%length([],A,A).
%length([_|T],A,N) :- B is A+1, length(T,B,N).

listify(X,[X]).
nil([]).
nonlist(X) :- constant(X), X \= [].
list([]).
list([H|T]) :- nonlist(H), list(T). 


%%% Primitive Set for Numeric Computation %%%
:- modeb(1,inc(+number,-number),[functional])?
:- modeb(1,-number is +number + +number,[functional])?
%:- modeb(1,-number is +number * +number,[functional])?
:- modeb(1,neg(+number,-number),[functional])?
:- modeb(1,inv(+number,-number),[functional])?
%%% Entailments
:- _ is X+Y prevents _ is Y+X?
:- _ is X*Y prevents _ is Y*X?
:- prevent neg(X,X)?
:- prevent inv(X,X)?
:- neg(_,Y) => neg(Y,_)?
:- inv(_,Y) => inv(Y,_)?

%%% Numeric Definitions
inc(X,Y) :- Y is X+1.
neg(X,Y) :- Y is -X.
inv(X,Y) :- Y is 1/X.


%%% Primitive Set for Ordering %%%
:- modeb(1,+number =:= +number)?
:- modeb(1,+number =\= +number)?
:- modeb(1,+number < +number)?
:- modeb(1,+number =< +number)?
%%% Entailments
:- prevent X =:= X? % reflexivity
:- X =:= Y prevents Y =:= X? % symmetry
%:- X =:= Y, Y =:= Z => X =:= Z? % transitive
%:- X =:= Y, X =:= Z => Y =:= Z? % left euclidean
%:- Y =:= X, Z =:= X => Y =:= Z? % right euclidean

:- prevent X =\= X?
:- X =\= Y prevents Y =\= X?

:- prevent X < X?
%:- X < Y, Y < Z => X < Z?

:- prevent X =< X?
%:- X =< Y, Y =< Z => X =< Z?

% Sub-Relations
:- X =:= Y => X =< Y?
:- X < Y => X =< Y?
